/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Fibre Channel Host Bus Adapters.                                *
 * Copyright (C) 2003-2005 Emulex.  All rights reserved.           *
 * EMULEX and SLI are trademarks of Emulex.                        *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of version 2 of the GNU General       *
 * Public License as published by the Free Software Foundation.    *
 * This program is distributed in the hope that it will be useful. *
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND          *
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,  *
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE      *
 * DISCLAIMED, EXCEPT TO THE EXTENT THAT SUCH DISCLAIMERS ARE HELD *
 * TO BE LEGALLY INVALID.  See the GNU General Public License for  *
 * more details, a copy of which can be found in the file COPYING  *
 * included with this package.                                     *
 *******************************************************************/

/*
 * $Id: lpfc_misc.h 2720 2005-11-28 18:58:48Z sf_support $
 */

#ifndef _H_LPFC_MISC
#define _H_LPFC_MISC

//SIP: #define HBA_EVENTS_SUPPORTED

#define LPFC_MAX_HOST 256
#define LPFC_MAX_EVENT 128

enum dfc_fabric_event_code {
	DFC_EVT_UNSOL_CT,
	DFC_EVT_UNSOL_ELS,
};

#define SLI_CT_ELX_LOOPBACK 0x10

enum ELX_LOOPBACK_CMD {
	ELX_LOOPBACK_XRI_SETUP,
	ELX_LOOPBACK_DATA,
};

#define ELX_LOOPBACK_HEADER_SZ \
	(size_t)(&((struct lpfc_sli_ct_request *)NULL)->un)

#ifndef HBA_EVENTS_SUPPORTED
enum lpfc_host_event_code  {
	LPFCH_EVT_LIP            = 0x1,
	LPFCH_EVT_LINKUP         = 0x2,
	LPFCH_EVT_LINKDOWN       = 0x3,
	LPFCH_EVT_LIPRESET       = 0x4,
	LPFCH_EVT_RSCN           = 0x5,
	LPFCH_EVT_ADAPTER_CHANGE = 0x103,
	LPFCH_EVT_PORT_UNKNOWN   = 0x200,
	LPFCH_EVT_PORT_OFFLINE   = 0x201,
	LPFCH_EVT_PORT_ONLINE    = 0x202,
	LPFCH_EVT_PORT_FABRIC    = 0x204,
	LPFCH_EVT_LINK_UNKNOWN   = 0x500,
	LPFCH_EVT_VENDOR_UNIQUE  = 0xffff,
};

#endif
struct lpfc_host_event {
	uint32_t seq_num;
	enum lpfc_host_event_code event_code;
	uint32_t data;
};


struct lpfcdfc_event {
	struct list_head node;
	int ref;
	wait_queue_head_t wq;

	/* Event type and waiter identifiers */
	uint32_t type_mask;
	uint32_t req_id;
	uint32_t reg_id;

	 /* next two flags are here for the auto-delete logic */
	unsigned long wait_time_stamp;
	int waiting;

	/* seen and not seen events */
	struct list_head events_to_get;
	struct list_head events_to_see;
};

struct event_data {
	struct list_head node;
	uint32_t type;
	uint32_t immed_dat;
	void * data;
	uint32_t len;
};

static inline struct lpfcdfc_event * lpfcdfc_event_new(uint32_t ev_mask,
						       int      ev_reg_id,
						       uint32_t ev_req_id)
{
	struct  lpfcdfc_event * evt = kzalloc(sizeof(*evt), GFP_KERNEL);
	if (evt == NULL)
		return NULL;

	INIT_LIST_HEAD(&evt->events_to_get);
	INIT_LIST_HEAD(&evt->events_to_see);
	evt->type_mask = ev_mask;
	evt->req_id = ev_req_id;
	evt->reg_id = ev_reg_id;
	evt->wait_time_stamp = jiffies;
	init_waitqueue_head(&evt->wq);

	return evt;
}

static inline void lpfcdfc_event_free(struct lpfcdfc_event * evt)
{
	struct event_data  * ed;

	list_del(&evt->node);

	while(!list_empty(&evt->events_to_get)) {
		ed = list_entry(evt->events_to_get.next, typeof(*ed), node);
		list_del(&ed->node);
		if(ed->data != NULL)
			kfree(ed->data);
		kfree(ed);
	}

	while(!list_empty(&evt->events_to_see)) {
		ed = list_entry(evt->events_to_see.next, typeof(*ed), node);
		list_del(&ed->node);
		if(ed->data != NULL)
			kfree(ed->data);
		kfree(ed);
	}

	kfree(evt);
}

#define lpfcdfc_event_ref(evt) evt->ref++

#define lpfcdfc_event_unref(evt)		\
	if (--evt->ref < 0)			\
		lpfcdfc_event_free(evt);

struct lpfcdfc_host {
	struct list_head node;
	int inst;
	struct lpfc_hba * phba;
	struct Scsi_Host * host;
	struct pci_dev * dev;
	struct {
		struct lpfc_host_event buf[LPFC_MAX_EVENT];
		uint32_t get;
		uint32_t put;
		uint32_t cnt;
		uint32_t missed;
	} hbaevt;
#ifndef HBA_EVENTS_SUPPORTED
	int32_t  last_hba_state;
	uint32_t last_fc_flag;
	int32_t  kill_active;
#endif
        void (*base_ct_unsol_event)(struct lpfc_hba *,
				    struct lpfc_sli_ring *,
				    struct lpfc_iocbq *);
        void (*base_els_unsol_event)(struct lpfc_hba *,
				     struct lpfc_sli_ring *,
				     struct lpfc_iocbq *);
	/* Threads waiting for async event */
	struct list_head ev_waiters;
};



#ifndef SLI_IOCB_USE_TXQ
#define SLI_IOCB_USE_TXQ    1       /* Queue IOCB to txq if cmd ring full */
#endif

#ifndef FC_BYPASSED_MODE
#define FC_BYPASSED_MODE    0x8000 /* Interface is offline for diag */
#endif

#define LPFC_DFT_POST_IP_BUF            128
#define LPFC_MIN_POST_IP_BUF            64
#define LPFC_MAX_POST_IP_BUF            1024
#define LPFC_DFT_XMT_QUE_SIZE           256
#define LPFC_MIN_XMT_QUE_SIZE           128
#define LPFC_MAX_XMT_QUE_SIZE           10240
#define LPFC_DFT_TOPOLOGY               0
#define LPFC_DFT_FC_CLASS               3

#define LPFC_DFT_NO_DEVICE_DELAY        1	/* 1 sec */
#define LPFC_MAX_NO_DEVICE_DELAY        30	/* 30 sec */
#define LPFC_DFT_EXTRA_IO_TIMEOUT       0
#define LPFC_MAX_EXTRA_IO_TIMEOUT       255	/* 255 sec */
#define LPFC_DFT_LNKDWN_TIMEOUT         30
#define LPFC_MAX_LNKDWN_TIMEOUT         255	/* 255 sec */
#define LPFC_DFT_NODEV_TIMEOUT          30
#define LPFC_MAX_NODEV_TIMEOUT          255	/* 255 sec */
#define LPFC_DFT_RSCN_NS_DELAY          0
#define LPFC_MAX_RSCN_NS_DELAY          255	/* 255 sec */

#define LPFC_MAX_HBA_Q_DEPTH            10240	/* max cmds allowed per hba */
#define LPFC_DFT_HBA_Q_DEPTH            2048	/* max cmds per hba */
#define LPFC_LC_HBA_Q_DEPTH             1024	/* max cmds per low cost hba */
#define LPFC_LP101_HBA_Q_DEPTH          128	/* max cmds per low cost hba */

#define LPFC_MAX_TGT_Q_DEPTH            10240	/* max cmds allowed per tgt */
#define LPFC_DFT_TGT_Q_DEPTH            0	/* default max cmds per tgt */

#define LPFC_MAX_LUN_Q_DEPTH            128	/* max cmds to allow per lun */
#define LPFC_DFT_LUN_Q_DEPTH            30	/* default max cmds per lun */

#define LPFC_MAX_DQFULL_THROTTLE        1	/* Boolean (max value) */

#define LPFC_MAX_DISC_THREADS           64	/* max outstanding discovery els
						   requests */
#define LPFC_DFT_DISC_THREADS           32	/* default outstanding discovery
						   els requests */

#define LPFC_MAX_NS_RETRY               3	/* Try to get to the NameServer
						   3 times and then give up. */

#define LPFC_MAX_SCSI_REQ_TMO           255	/* Max timeout value for SCSI
						   passthru requests */
#define LPFC_DFT_SCSI_REQ_TMO           30	/* Default timeout value for
						   SCSI passthru requests */

#define LPFC_MAX_TARGET                 256	/* max nunber of targets
						   supported */
#define LPFC_DFT_MAX_TARGET             256	/* default max number of targets
						   supported */

#define LPFC_DFT_MAX_LUN                32768	/* default max number of LUNs
						   supported */

struct lpfc_dmabufext {
        struct lpfc_dmabuf dma;
        uint32_t size;
        uint32_t flag;
};
typedef struct lpfc_dmabufext DMABUFEXT_t;

DMABUFEXT_t * dfc_cmd_data_alloc(struct lpfc_hba * phba, char *indataptr,
				 struct ulp_bde64 * bpl, uint32_t size);

int dfc_cmd_data_free(struct lpfc_hba * phba, DMABUFEXT_t * mlist);

/*
 * This file declares the functions exported by lpfc_misc.c
 */

struct lpfc_nodelist *lpfc_findnode_wwpn(struct lpfc_hba *, uint32_t,
				    struct lpfc_name *);
struct lpfc_nodelist *lpfc_findnode_wwnn(struct lpfc_hba *, uint32_t,
				    struct lpfc_name *);

int
lpfc_issue_ct_rsp(struct lpfc_hba * phba, uint32_t tag, struct lpfc_dmabuf * bmp,
		  DMABUFEXT_t * inp);

void
lpfc_sli_wake_iocb_wait(struct lpfc_hba *, struct lpfc_iocbq *,
				    struct lpfc_iocbq *);
void
lpfc_sli_wake_mbox_wait(struct lpfc_hba * phba, LPFC_MBOXQ_t * pmboxq);

int
lpfc_sleep(struct lpfc_hba * phba, void *wait_q_head, long tmo);

/* Forward declarations to prevent compiler warnings */
int lpfc_scsi_lun_reset(struct lpfc_scsi_buf *, struct lpfc_hba *, uint32_t);
int lpfc_scsi_tgt_reset(struct lpfc_scsi_buf *, struct lpfc_hba *, uint32_t);
struct lpfc_iocbq *lpfc_prep_els_iocb(struct lpfc_hba *, uint8_t expectRsp,
				      uint16_t, uint8_t, struct lpfc_nodelist *,
				      uint32_t, uint32_t);
struct lpfc_bindlist *lpfc_assign_scsid(struct lpfc_hba *,
					struct lpfc_nodelist *, int);
struct lpfc_scsi_buf* lpfc_get_scsi_buf(struct lpfc_hba * phba);
void lpfc_release_scsi_buf(struct lpfc_hba * phba, struct lpfc_scsi_buf * psb);
int lpfc_geportname(struct lpfc_name * pn1, struct lpfc_name * pn2);
int lpfc_issue_lip(struct Scsi_Host *host);

#define LPFC_EXTERNAL_RESET 1
#define LPFC_ISSUE_LUN_RESET 2
#define LPFC_ISSUE_ABORT_TSET 4

#define TRUE 1
#define FALSE 0
/* values for a_flag */
#define CFG_EXPORT      0x1	/* Export this parameter to the end user */
#define CFG_IGNORE      0x2	/* Ignore this parameter */
#define CFG_DEFAULT     0x8000	/* Reestablishing Link */

/* values for a_changestate */
#define CFG_REBOOT      0x0	/* Changes effective after ystem reboot */
#define CFG_DYNAMIC     0x1	/* Changes effective immediately */
#define CFG_RESTART     0x2	/* Changes effective after driver restart */

#define LPFC_SCSI_BUF_SZ        1024  /* used for driver generated scsi cmds */
#define LPFC_SCSI_PAGE_BUF_SZ   4096  /* used for driver RPTLUN cmds */
#define LPFC_INQSN_SZ           64    /* Max size of Inquiry serial number */

/* 
   This is the context structure used for a timed-out iocb
   to free resources used for the iocb.
*/
void
lpfc_ioctl_timeout_iocb_cmpl(struct lpfc_hba *,
			     struct lpfc_iocbq *, struct lpfc_iocbq *);

struct lpfc_timedout_iocb_ctxt {
       struct lpfc_iocbq *rspiocbq;
       struct lpfc_dmabuf *mp;
       struct lpfc_dmabuf *bmp;
       struct lpfc_scsi_buf *lpfc_cmd;
       DMABUFEXT_t *outdmp;
       DMABUFEXT_t *indmp;
};

enum get_phba_flag {
	FIND_HBA,
	VALIDATE_HBA,
};

struct lpfcdfc_host * lpfcdfc_get_phba_by_inst(int inst, enum get_phba_flag val_flag);

struct lpfcdfc_host * lpfcdfc_host_from_hba(struct lpfc_hba * phba);

int lpfc_linkinfo(struct lpfc_hba * phba, LinkInfo *linkinfo);

#ifdef HBA_EVENTS_SUPPORTED
void lpfcdfc_host_event(struct lpfc_hba * phba,
                                enum lpfc_host_event_code evc,
                                uint32_t data);
#else
int lpfcdfc_do_ev_poll(void *);
#endif

void lpfcdfc_els_unsol_event(struct lpfc_hba *, struct lpfc_sli_ring *,
			     struct lpfc_iocbq *);
void lpfcdfc_ct_unsol_event(struct lpfc_hba *, struct lpfc_sli_ring *,
			    struct lpfc_iocbq *);


#endif				/* _H_LPFC_MISC */
